//---------------------------------------------------------------------------
//  BinClock   -   "Black-Standard" Binary Clock for Windows.
//  R. Black - started 22 March 2007 - www.RomanBlack.com
//  (set tab = 3 spaces, use monospaced font like courier)
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include <dos.h>				// only gettime() and getdate()
#include <stdio.h>			// only sprintf()

#include "Unit1.h"
#include "Unit2.h"


// my globals below
int toggle=0;
int hdiff=0;
int wdiff=0;

#define clrDark 		TColor(0x00464646) 	// my colour for unlit segments


//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}

//=========================================================================
//  CREATE THE FORM - done first
//=========================================================================
void __fastcall TForm1::FormCreate(TObject *Sender)
{
   //--------------------------------------------------
   // reduce height at startup, as numerals are OFF
   // at startup.
   Form1->Height -= 18;   // and vert resize
}
//---------------------------------------------------------------------------


//=========================================================================
//  SELECT COLOUR - segment color is selected based on Form2 radio buttons
//=========================================================================
void select_colour(void)
{
 	if(Form2->RadioButton1->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clRed;
   	Form1->Canvas->Brush->Color = clRed;
	   Form1->Canvas->Font->Color = clRed;
   }
 	if(Form2->RadioButton2->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clBlue;
   	Form1->Canvas->Brush->Color = clBlue;
	   Form1->Canvas->Font->Color = clBlue;
   }
 	if(Form2->RadioButton3->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clLime;
   	Form1->Canvas->Brush->Color = clLime;
	   Form1->Canvas->Font->Color = clLime;
   }
 	if(Form2->RadioButton4->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clYellow;
   	Form1->Canvas->Brush->Color = clYellow;
	   Form1->Canvas->Font->Color = clYellow;
   }
 	if(Form2->RadioButton5->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clWhite;
   	Form1->Canvas->Brush->Color = clWhite;
	   Form1->Canvas->Font->Color = clWhite;
   }
 	if(Form2->RadioButton6->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clFuchsia;
   	Form1->Canvas->Brush->Color = clFuchsia;
	   Form1->Canvas->Font->Color = clFuchsia;
   }
 	if(Form2->RadioButton7->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clAqua;
   	Form1->Canvas->Brush->Color = clAqua;
	   Form1->Canvas->Font->Color = clAqua;
   }
 	if(Form2->RadioButton8->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clSkyBlue;
   	Form1->Canvas->Brush->Color = clSkyBlue;
	   Form1->Canvas->Font->Color = clSkyBlue;
   }
}
//---------------------------------------------------------------------------


//=========================================================================
//  SELECT UNLIT COLOUR - show unlit segments as grey or black
//=========================================================================
void select_ucolour(void)
{
	//--------------------------------------------------
   // Controlled by Form2->Checkbox2, is "Show unlit segments"
 	if(Form2->CheckBox2->Checked == true)
   {
   	Form1->Canvas->Pen->Color = clrDark;
   	Form1->Canvas->Brush->Color = clrDark;   // TColor
   }
	else 		// else default to black
   {
   	Form1->Canvas->Pen->Color = clBlack;
   	Form1->Canvas->Brush->Color = clBlack;
   }
}
//---------------------------------------------------------------------------


//=========================================================================
//  TIMER1  -  does this function every timer tick (1000mS)
//=========================================================================
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{

   struct time the_time;	// time in struct for gettime()
   TPoint points[5];  		// used for drawing polygon()

   int hour=0;   				// used for displaying segments
   int min=0;

   char tstring[80];       // temp for text display
	//--------------------------------------------------
	// Get the current time.
   gettime(&the_time);

   // change from 24 hour time to 12 hour
   if(the_time.ti_hour==0) the_time.ti_hour=12; 	// force no zero
   if(the_time.ti_hour>12) the_time.ti_hour-=12;   // force 12 hour time

	//--------------------------------------------------
	// Next decode and draw all the binary segments,
   // by chiseling away at the hour and min variables.

   // prep variables first
   hour = the_time.ti_hour;
   min = the_time.ti_min;

	// then prep coord stuff
	int tx,ty;						// coords, top left corner of clock face
   int g;							// gap between segments
   int y1,y2,y3,y4,y5,y6;		// used for x,y polygon() coords

   g=5;								// gap between segments (in pixels)

 	// Bastard WinXP problem! It forces too large a form,
   // so must use auto sizing here to put clock face in middle
   // of the black form area that XP chose;

   // calc pos of left top corner of the clock face.
   tx = ( (Form1->ClientWidth / 2) - 36 );
   ty = ( (Form1->ClientHeight / 2) - 27 );

	// also change vert centre if showing numerals!
   if(Form2->CheckBox1->Checked == true) ty -= 8;

	//--------------------------------------------------
   // draw quarters first

   y1=0;   		// top y of quarters
   y2=y1+12;   // height of quarters

   // draw quarter 30
   if(min>=30)
   {
   	min-=30;
      select_colour();
   }
   else
   {
      select_ucolour();
   }
  	points[0] = Point(tx+11,ty+y2); 			// draw Q30 polygon
  	points[1] = Point(tx+11+22,ty+y2);
  	points[2] = Point(tx+11+22,ty+y1);
  	points[3] = Point(tx+11+22-12,ty+y1+2);
  	Canvas->Polygon(points, 3);

   // draw quarter 15
   if(min>=15)
   {
   	min-=15;
      select_colour();
   }
   else
	{
      select_ucolour();
   }
  	points[0] = Point(tx+11+22+g,ty+y2); 			// draw Q15 polygon
  	points[1] = Point(tx+11+22+g+22,ty+y2);
  	points[2] = Point(tx+11+22+g+12,ty+y1+2);
  	points[3] = Point(tx+11+22+g,ty+y1);
  	Canvas->Polygon(points, 3);

	//--------------------------------------------------
   // draw hours

   y3=y2+g;   		// top y of hours
   y4=y3+24;   	// height of hours

   // draw H8
   if(hour>=8)
   {
   	hour-=8;
      select_colour();
   }
   else
   {
      select_ucolour();
   }
  	points[0] = Point(tx+0,ty+y4); 			// draw H8 polygon
  	points[1] = Point(tx+12,ty+y4);
  	points[2] = Point(tx+12+9,ty+y3);
  	points[3] = Point(tx+0+9,ty+y3);
  	Canvas->Polygon(points, 3);

   // draw H4
   if(hour>=4)
   {
   	hour-=4;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+12+g,ty+y4); 			// draw H4 polygon
  	points[1] = Point(tx+12+g+16,ty+y4);
  	points[2] = Point(tx+12+g+16,ty+y3);
  	points[3] = Point(tx+12+9+g,ty+y3);
  	Canvas->Polygon(points, 3);

   // draw H2
   if(hour>=2)
   {
   	hour-=2;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+12+g+16+g,ty+y4); 			// draw H2 polygon
  	points[1] = Point(tx+12+g+16+g+16,ty+y4);
  	points[2] = Point(tx+12+g+16+g+16-9,ty+y3);
  	points[3] = Point(tx+12+g+16+g,ty+y3);
  	Canvas->Polygon(points, 3);

   // draw H1
   if(hour>=1)
   {
   	hour-=1;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+12+g+16+g+16+g,ty+y4); 			// draw H1 polygon
  	points[1] = Point(tx+12+g+16+g+16+g+12,ty+y4);
  	points[2] = Point(tx+12+g+16+g+16+g+12-9,ty+y3);
  	points[3] = Point(tx+12+g+16+g+16+g-9,ty+y3);
  	Canvas->Polygon(points, 3);

	//--------------------------------------------------
	// draw minutes
   y5=y4+g;   		// top y of minutes
   y6=y5+6;   		// height of minutes

   // draw M8
   if(min>=8)
   {
   	min-=8;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+0+3,ty+y6); 			// draw M8 polygon
  	points[1] = Point(tx+12+3,ty+y6);
  	points[2] = Point(tx+12,ty+y5);
  	points[3] = Point(tx+0,ty+y5);
  	Canvas->Polygon(points, 3);

   // draw M4
   if(min>=4)
   {
   	min-=4;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+12+g+3,ty+y6); 			// draw M4 polygon
  	points[1] = Point(tx+12+g+16,ty+y6);
  	points[2] = Point(tx+12+g+16,ty+y5);
  	points[3] = Point(tx+12+g+0,ty+y5);
  	Canvas->Polygon(points, 3);

   // draw M2
   if(min>=2)
   {
   	min-=2;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+16+g+12+g,ty+y6); 			// draw M2 polygon
  	points[1] = Point(tx+16+g+12+g+16-3,ty+y6);
  	points[2] = Point(tx+16+g+12+g+16,ty+y5);
  	points[3] = Point(tx+16+g+12+g+0,ty+y5);
  	Canvas->Polygon(points, 3);

   // draw M1
   if(min>=1)
   {
   	min-=1;
      select_colour();
   }
   else
   {
      select_ucolour();
	}
  	points[0] = Point(tx+16+g+16+g+12+g-3,ty+y6); 		// draw M1 polygon
  	points[1] = Point(tx+16+g+16+g+12+g+12-3,ty+y6);
  	points[2] = Point(tx+16+g+16+g+12+g+12,ty+y5);
  	points[3] = Point(tx+16+g+16+g+12+g+0,ty+y5);
  	Canvas->Polygon(points, 3);

   //--------------------------------------------------
 	// Display time as numerals (if that option is selected)
   // if not selected, draw numbers in black (invisible)

	// WinXP probs! Bastard XP forces the wrong size font!
   // Now forced to use canvas drawing...

   if(Form2->CheckBox1->Checked == true)
   {
  		sprintf(tstring,"%02d:%02d:%02d",the_time.ti_hour,
   					the_time.ti_min,the_time.ti_sec);	// format all digits
		Form1->Canvas->Font->Size = 10;
   	select_colour();				// set text colour to selected
   	Form1->Canvas->Brush->Color = clBlack;    // text background colour

		if(Form1->ClientHeight < 85)		// if NOT WinXP
			Form1->Canvas->TextOut(tx+12,ty+y6+g,tstring);	// draw the text
     	else 		// else is WinXP (and font wrong size!)
			Form1->Canvas->TextOut(tx+4,ty+y6+g,tstring);	// draw the text
   }
   //--------------------------------------------------
}
//---------------------------------------------------------------------------



//=========================================================================
//  MOUSE CLICK  -  Single click anywhere on the clock face
//=========================================================================
void __fastcall TForm1::FormClick(TObject *Sender)
{

	int height=0;
	int width=0;
	//--------------------------------------------------
   // toggle the form style between standard windows (dialog)
   // and borderless black style.

   if(toggle==0)
   {
      height = Form1->ClientHeight; 	// calc new height
      hdiff = (Form1->Height - Form1->ClientHeight);

      width = Form1->ClientWidth; 		// calc new width
      wdiff = (Form1->Width - Form1->ClientWidth);

      Form1->Height = height;    		// and resize
      Form1->Width = width;
   	Form1->BorderStyle = bsNone;  	// remove border
   	toggle=1;
   }
   else
   {
      Form1->Height = (Form1->Height + hdiff);    // and resize
      Form1->Width = (Form1->Width + wdiff);
   	Form1->BorderStyle = bsDialog;  	// restore border
   	toggle=0;
   }
   // refresh the clock display to avoid blank delay
	Timer1Timer(Form1);

}
//---------------------------------------------------------------------------


//=========================================================================
//  RIGHT CLICK  -  Right mouse click anywhere on the clock face
//=========================================================================
void __fastcall TForm1::FormMouseDown(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
	//--------------------------------------------------
	// Check for right mouse button click, and if so,
   // then open Form2. Form2 is the "options" form.
   if(Button == mbRight)  Form2->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormResize(TObject *Sender)
{
	//--------------------------------------------------
   // Redraw the form after resizing it!
   Form1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormPaint(TObject *Sender)
{
   // refresh the clock display to avoid blank delay
	Timer1Timer(Form1);
}
//---------------------------------------------------------------------------

