/******************************************************************************
    SG_Adv_Text.c     Advanced text, making custom text characters.
    Copyright:        Open-Source, Jan2011, written by www.RomanBlack.com
    MCU:              P18F8527
    Dev.Board:        SmartGLCD (SmartGLCD 240x128 module)
    Oscillator:       HSPLL 32.0 MHz (8MHz xtal)
    Compiler:         MikroC v7.0 (or MikroC PRO 4.0)

  This sets the user CG ram (Character Generator ram) to ram block 3
  (blocks are 2048 bytes size). Then it writes 4 custom characters directly
  into the user CG ram area. After that, the custom characters can be
  written to the screen using the standard MikroC text and char functions.
  Note! There are a maximum of 128 custom characters available which will
  draw extremely fast to the screen, as they draw as text. This can let you
  build icons or small images out of a group of custom characters and
  draw the icon to the screen VERY fast.
  // NOTE! GLCD is in narrow text mode (6x8 font) giving 40x16 chars.
******************************************************************************/
// Global Variables
unsigned char i;          // used for loops


#include "T6963C_MikroC.h"      // include this if using MikroC (older)
//#include "T6963C_MikroC_PRO.h"  // include this if using MikroC PRO


//=============================================================================
//  MAIN
//=============================================================================
void main()
{
  //-------------------------------------------------------
  // setup PIC 18F8527 for SmartGLCD pins
  CMCON = 0x07;        // turn off comparators (make all pins digital)
  ADCON0 = 0b00000001;  // ADC module on
  ADCON1 = 0b00001101;  // AN0,AN1 are adc inputs, 0v-5v range
  ADCON2 = 0b00110010;  // ADC result left justified (0-255 range)

  LATA =  0b00000000;
  TRISA = 0b00000011;   // RA0,RA1 analog inputs (TP)
  LATC =  0b00000110;   // LEDs off at start
  TRISC = 0b00000000;   // C1, C2 backlight LED
  LATG =  0b00000001;   // LED off at start
  TRISG = 0b00000000;   // G0 backlight LED
  
  LATJ  = 0b01000000;   // RJ6=FS (1=font6 0=font8), RJ5=MD
  TRISJ = 0b00000000;   // GLCD control port

  BacklightRed    = 1;     // control the GLCD backlight leds; 0=on, 1=off
  BacklightGreen  = 0;     // green ON
  BacklightBlue   = 1;

  T1CON = 0b10110001;   // TMR1 on 16bit, 1:8 prescaler, used for time testing

  //-------------------------------------------------------
  // Initialize T6963C GLCD
  //T6963C_init(240, 128, 6);   // init for MikroC PRO version
  T6963C_init(240, 128, 6, &PORTH, &PORTJ, 2, 1, 0, 4); // init for MikroC version
  T6963C_graphics(1);       // graphics mode = on
  T6963C_text(1);           // text mode = on (now both are on)
  T6963C_cursor(0);         // cursor = off

  Delay_mS(300);

  //-------------------------------------------------------
  // NOTE! GLCD is in narrow text mode (6x8 font) giving 40x16 chars.
  //-------------------------------------------------------
  // Special GLCD setup for custom characters.
  // Do "offset register set" to set character ram address to the first
  // available block of 2048 ram, which is block 3 (at 6144)
  T6963C_writeData(0x03);     // ram block 3 (each block = 2048)
  T6963C_writeData(0x00);     // must be zero
  T6963C_writeCommand(0x22);  // command for "offset register set"

  // Set the ram address for the first CG character at location 224 which
  // will be displayed my MikroC char functions at location 0 as MikroC
  // references text as -32. (so 0-32 becomes 224)
  // The ram address is (block*3)+(224*8) because there are 8 bytes per character.
  // So ram address is 6144+1792 = 7936 = 0x1F00
  T6963C_writeData(0x00);     // ram lo address
  T6963C_writeData(0x1F);     // ram hi address
  T6963C_writeCommand(0x24);  // command to set ram address pointer
  
  // Now write the 8 bytes to draw a custom character.
  // format is horizontal bytes, top down. As we are in 6x8 font mode
  // only the right hand 6 bits are used, and the bit5 should be blank
  // as there should (normally) be 5 character bits and one blank space bit.
  // With text characters the bottom byte is normally blank too.
  
  // make custom character; BLOCK
  T6963C_writeData(0b00011111); // bits; xxBBBBBB
  T6963C_writeCommand(0xC0);    // command to write byte to graphic ram and inc ram pointer
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000000);     
  T6963C_writeCommand(0xC0);  

  // NOTE! as address is auto incrementing we can just keep adding more
  // chars without needing to send another address command! 
  // make custom character; UP ARROW
  T6963C_writeData(0b00000100); // bits; xxBBBBBB
  T6963C_writeCommand(0xC0);    // command to write byte to graphic ram and inc ram pointer
  T6963C_writeData(0b00000100);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001110);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001110);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011011);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000000);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000000);     
  T6963C_writeCommand(0xC0);  

  // make custom character; DOWN ARROW
  T6963C_writeData(0b00011011); // bits; xxBBBBBB    
  T6963C_writeCommand(0xC0);    // command to write byte to graphic ram and inc ram pointer
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001110);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001110);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000100);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000100);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000000);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000000);     
  T6963C_writeCommand(0xC0);  

  // make custom character; MAN
  T6963C_writeData(0b00010001); // bits; xxBBBBBB
  T6963C_writeCommand(0xC0);    // command to write byte to graphic ram and inc ram pointer
  T6963C_writeData(0b00010101);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011111);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000100);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00000100);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001110);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00001010);     
  T6963C_writeCommand(0xC0);  
  T6963C_writeData(0b00011011);     
  T6963C_writeCommand(0xC0);  
                      
  //-------------------------------------------------------
  // now draw it all to screen
  T6963C_Write_Text("User-made custom characters!", 0, 0, T6963C_ROM_MODE_OR);  

  T6963C_Write_Text("Block", 0, 2, T6963C_ROM_MODE_OR);  
  T6963C_Write_Char(0,12,2,T6963C_ROM_MODE_OR);   // custom char 0 (224)

  T6963C_Write_Text("Up Arrow", 0, 4, T6963C_ROM_MODE_OR);  
  T6963C_Write_Char(1,12,4,T6963C_ROM_MODE_OR);   // custom char 1 (225)

  T6963C_Write_Text("Down Arrow", 0, 6, T6963C_ROM_MODE_OR);  
  T6963C_Write_Char(2,12,6,T6963C_ROM_MODE_OR);   // custom char 2 (226)

  T6963C_Write_Text("Little Man", 0, 8, T6963C_ROM_MODE_OR);  
  T6963C_Write_Char(3,12,8,T6963C_ROM_MODE_OR);   // custom char 3 (227)

  //-------------------------------------------------------
  while(1)
  {
    // just loop and do nothing
  }
}
//-----------------------------------------------------------------------------





