/******************************************************************************
  TPfact.c   - open source - written by www.RomanBlack.com

  TPfast are functions for TouchPanel reading on MikroE SmartGLCD240x128 module.
  These are high performance stripped down functions for reading X or Y
  of the Touch Panel, and they do not have any of the refined features of
  the MikroE TP library functions. Only a single byte value is returned
  for the X or Y, which represents ADC of 0-255 for the X or Y axis.
  These functions are very small and fast and can be called in the middle
  of time sensitive code to get a TP X or Y value.
  NOTE! Add a small delay (500uS?) after changing SetX or SetY to allow the
  PIC ADC to settle.
******************************************************************************/

//=============================================================================
//  TPFAST SETX
//=============================================================================
void TPfast_SetX(void)
{
  //-------------------------------------------------------
  // RomanBlack's high performance TouchPanel read functions for
  // SmartGLCD240x128 module; Jan 2011 - open source.
  // Call this function to set up the TP to read the X axis.
  // Note! If you have changed axis, there must be a delay of at least
  // 500uS before reading the new selected axis (to allow ADC to settle).
  //-------------------------------------------------------
  // set the PIC pins so it can read the TP X axis
  LATA.F5 = 0;    // set DRIVEA and DRIVEB pins to TP
  LATA.F2 = 1;   

  // set the ADC to read from the now floating pin (TP BOTTOM on RA0)
  ADCON0 = 0b00000001;  // adc channel AN0 is selected
}
//-----------------------------------------------------------------------------

//=============================================================================
//  TPFAST SETY
//=============================================================================
void TPfast_SetY(void)
{
  //-------------------------------------------------------
  // RomanBlack's high performance TouchPanel read functions for
  // SmartGLCD240x128 module; Jan 2011 - open source.
  // Call this function to set up the TP to read the Y axis.
  // Note! If you have changed axis, there must be a delay of at least
  // 500uS before reading the new selected axis (to allow ADC to settle).
  //-------------------------------------------------------
  // set the PIC pins so it can read the TP Y axis
  LATA.F2 = 0;    // set DRIVEA and DRIVEB pins to TP
  LATA.F5 = 1;    //

  // set the ADC to read from the now floating pin (TP LEFT on RA1)
  ADCON0 = 0b00000101;  // adc channel AN1 is selected
}
//-----------------------------------------------------------------------------

//=============================================================================
//  TPFAST STARTREAD
//=============================================================================
void TPfast_StartRead(void)
{
  //-------------------------------------------------------
  // RomanBlack's high performance TouchPanel read functions for
  // SmartGLCD240x128 module; Jan 2011 - open source.
  // Call this function to start an ADC read of the TP.
  //-------------------------------------------------------
  // read either X or Y axis of the touchpanel, based on
  // the TP axis which was last set up.
  ADCON0.F1 = 1;  // initiate a ADC read
}
//-----------------------------------------------------------------------------

//=============================================================================
//  TPFAST READ
//=============================================================================
unsigned char TPfast_Read(void)
{
  //-------------------------------------------------------
  // RomanBlack's high performance TouchPanel read functions for
  // SmartGLCD240x128 module; Jan 2011 - open source.
  // Call this function to get the ADC value of the TP.
  //-------------------------------------------------------
  // get either X or Y axis of the touchpanel, based on
  // the TP axis which was last set up.
  
  // wait for adc conversion to finish if it is still going!
  while(ADCON0.F1) continue;
  
  // then get the adc result (0-255) and return it
  return(ADRESH); 
}
//-----------------------------------------------------------------------------

